/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import wile.redstonepen.libmc.Auxiliaries;

public class ExtendedShapelessRecipe
implements class_3955 {
    private final String group;
    private final class_7710 category;
    private final class_1799 result;
    private final class_2371<class_1856> ingredients;
    private final class_2487 aspects;
    public static final Serializer SERIALIZER = new Serializer();

    public ExtendedShapelessRecipe(String group, class_7710 cat, class_1799 output, class_2371<class_1856> ingredients, class_2487 aspects) {
        this.group = group;
        this.category = cat;
        this.result = output;
        this.ingredients = ingredients;
        this.aspects = aspects;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 method_45441() {
        return this.category;
    }

    public class_2487 getAspects() {
        return this.aspects.method_10553();
    }

    public boolean method_8118() {
        return this.isRepair() || this.aspects.method_10577("dynamic");
    }

    public class_1799 method_8110(class_7225.class_7874 ra) {
        return this.method_8118() ? class_1799.field_8037 : this.result;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8113(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public class_2371<class_1799> getRemainingItems(class_9694 inv) {
        if (this.isRepair()) {
            class_2371 remaining = (class_2371)this.getRepaired(inv).method_15441();
            for (int i = 0; i < remaining.size(); ++i) {
                class_1799 rem_stack = (class_1799)remaining.get(i);
                class_1799 inv_stack = inv.method_59984(i);
                if (inv_stack.method_7960() || !rem_stack.method_7960() && !inv.method_59984(i).method_31574(rem_stack.method_7909())) continue;
                remaining.set(i, (Object)class_1799.field_8037);
                if (!rem_stack.method_7960()) {
                    rem_stack.method_7933(1);
                }
                inv_stack.method_7939(rem_stack.method_7947());
            }
            return remaining;
        }
        String tool_name = this.aspects.method_10558("tool");
        int tool_damage = this.getToolDamage();
        class_2371 remaining = class_2371.method_10213((int)inv.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < remaining.size(); ++i) {
            class_1799 stack = inv.method_59984(i);
            if (Auxiliaries.getResourceLocation(stack.method_7909()).toString().equals(tool_name)) {
                if (!stack.method_7963()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                class_1799 rstack = stack.method_7972();
                rstack.method_7974(rstack.method_7919() + tool_damage);
                if (rstack.method_7919() >= rstack.method_7936()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.method_7909().method_7857()) continue;
            remaining.set(i, (Object)new class_1799((class_1935)stack.method_7909().method_7858(), stack.method_7947()));
        }
        return remaining;
    }

    public boolean matches(class_9694 input, class_1937 world) {
        class_1662 stacked = new class_1662();
        int i = 0;
        for (int j = 0; j < input.method_59983(); ++j) {
            class_1799 ingr = input.method_59984(j);
            if (ingr.method_7960()) continue;
            stacked.method_20478(ingr, 1);
            ++i;
        }
        return i == this.ingredients.size() && stacked.method_7402((class_1860)this, null);
    }

    public class_1799 assemble(class_9694 inv, class_7225.class_7874 ra) {
        int dmg;
        if (this.isRepair()) {
            return (class_1799)this.getRepaired(inv).method_15442();
        }
        class_1799 rstack = this.result.method_7972();
        if (rstack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.aspects.method_10550("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.method_7936() - this.aspects.method_10550("initial_durability"));
            if (dmg2 > 0) {
                rstack.method_7974(dmg2);
            }
        } else if (this.aspects.method_10550("initial_damage") > 0 && (dmg = Math.min(this.aspects.method_10550("initial_damage"), rstack.method_7936())) > 0) {
            rstack.method_7974(dmg);
        }
        return rstack;
    }

    private int getToolDamage() {
        if (this.aspects.method_10545("tool_repair")) {
            return -class_3532.method_15340((int)this.aspects.method_10550("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.method_10545("tool_damage")) {
            return class_3532.method_15340((int)this.aspects.method_10550("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private class_3545<class_1799, class_2371<class_1799>> getRepaired(class_9694 inv) {
        class_1799 stack;
        int i;
        String tool_name = this.aspects.method_10558("tool");
        HashMap<class_1792, Integer> repair_items = new HashMap<class_1792, Integer>();
        class_2371 remaining = class_2371.method_10213((int)inv.method_59983(), (Object)class_1799.field_8037);
        class_1799 tool_item = class_1799.field_8037;
        for (int i2 = 0; i2 < inv.method_59983(); ++i2) {
            class_1799 stack2 = inv.method_59984(i2);
            if (stack2.method_7960()) continue;
            if (Auxiliaries.getResourceLocation(stack2.method_7909()).toString().equals(tool_name)) {
                tool_item = stack2.method_7972();
                continue;
            }
            remaining.set(i2, (Object)stack2.method_7972());
            repair_items.put(stack2.method_7909(), stack2.method_7947() + repair_items.getOrDefault(stack2.method_7909(), 0));
        }
        if (tool_item.method_7960()) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        if (!tool_item.method_7963()) {
            Auxiliaries.logWarn("Repairing '" + String.valueOf(Auxiliaries.getResourceLocation(tool_item.method_7909())) + "' can't work, the item is not damageable.");
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int dmg = tool_item.method_7919();
        if (dmg <= 0 && !this.aspects.method_10577("over_repair")) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int single_repair_dur = this.aspects.method_10577("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.method_7936() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (class_1792 ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.method_7974(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.method_59984(i);
            if (stack.method_7960() || Auxiliaries.getResourceLocation(stack.method_7909()).toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.method_7909().method_7857() ? new class_1799((class_1935)stack.method_7909().method_7858(), stack.method_7947()) : stack.method_7972()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (class_1799)remaining.get(i);
            class_1792 item = stack.method_7909();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.method_7947() >= n) {
                stack.method_7934(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.method_7947());
            remaining.set(i, (Object)class_1799.field_8037);
        }
        if (tool_item.method_7909() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.method_7909()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.method_7919());
        }
        return new class_3545((Object)tool_item, (Object)remaining);
    }

    public static class Serializer
    implements class_1865<ExtendedShapelessRecipe> {
        private static final MapCodec<ExtendedShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(r -> r.category), (App)class_1799.field_24671.fieldOf("result").forGetter(r -> r.result), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (class_1856[])list.stream().filter(ing -> !ing.method_8103()).toArray(class_1856[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "no ingredients");
            }
            if (ingredients.length > 9) {
                return DataResult.error(() -> "too many ingredients");
            }
            return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
        }, DataResult::success).forGetter(r -> r.ingredients), (App)class_2487.field_25128.optionalFieldOf("aspects", (Object)new class_2487()).forGetter(r -> r.aspects)).apply((Applicative)instance, ExtendedShapelessRecipe::new));
        public static final class_9139<class_9129, ExtendedShapelessRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ExtendedShapelessRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ExtendedShapelessRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static ExtendedShapelessRecipe fromNetwork(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 cat = (class_7710)buf.method_10818(class_7710.class);
            int size = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)size, (Object)class_1856.field_9017);
            ingredients.replaceAll(ingr -> (class_1856)class_1856.field_48355.decode((Object)buf));
            class_1799 stack = (class_1799)class_1799.field_48349.decode((Object)buf);
            class_2487 aspects = buf.method_10798();
            return new ExtendedShapelessRecipe(group, cat, stack, (class_2371<class_1856>)ingredients, aspects);
        }

        private static void toNetwork(class_9129 buf, ExtendedShapelessRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            buf.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                class_1856.field_48355.encode((Object)buf, (Object)ingredient);
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
            buf.method_10794((class_2520)recipe.getAspects());
        }
    }

    public static interface IRepairableToolItem {
        public class_1799 onShapelessRecipeRepaired(class_1799 var1, int var2, int var3);
    }
}

